//ADS1115 Library
#include <Wire.h>
#include <Adafruit_ADS1015.h>
Adafruit_ADS1115 ads;  /* Use this for the 16-bit version */
//Adafruit_ADS1015 ads;     /* Use thi for the 12-bit version */
//OLED Library
#include <SPI.h>
#include <Adafruit_GFX.h>         //download here: https://www.electronoobs.com/eng_arduino_Adafruit_GFX.php
#include <Adafruit_SSD1306.h>     //downlaod here: https://www.electronoobs.com/eng_arduino_Adafruit_SSD1306.php
#define OLED_RESET 5
Adafruit_SSD1306 display(OLED_RESET);




//Inputs/Outputs
int rightbutton = 8;
int leftbutton = 9;
int BoardTemp = A0;
int buzzer = 6;
int fanController = 5;

//Variables
bool rightbutton_State = false;
bool leftbutton_State = false;
int16_t peltierRead;
int16_t peltierReadtemp;
int16_t peltierOffset;
float multiplier = 0.015625F; /* ADS1115  @ +/- 6.144V gain (16-bit results) */

void setup() {
  pinMode(fanController, OUTPUT);
  pinMode(buzzer, OUTPUT);
  digitalWrite(fanController, LOW);
  digitalWrite(buzzer, LOW);
  pinMode(rightbutton, INPUT_PULLUP);
  pinMode(leftbutton, INPUT_PULLUP);
  pinMode(BoardTemp, INPUT);




  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3C (for the 128x32 or 64 from eBay)
  delay(100);
  display.clearDisplay();
  display.display();
  delay(100);

  // The ADC input range (or gain) can be changed via the following
  // functions, but be careful never to exceed VDD +0.3V max, or to
  // exceed the upper and lower limits if you adjust the input range!
  // Setting these values incorrectly may destroy your ADC!
  //                                                                ADS1015  ADS1115
  //                                                                -------  -------
  // ads.setGain(GAIN_TWOTHIRDS);  // 2/3x gain +/- 6.144V  1 bit = 3mV      0.1875mV (default)
  // ads.setGain(GAIN_ONE);        // 1x gain   +/- 4.096V  1 bit = 2mV      0.125mV
  // ads.setGain(GAIN_TWO);        // 2x gain   +/- 2.048V  1 bit = 1mV      0.0625mV
  // ads.setGain(GAIN_FOUR);       // 4x gain   +/- 1.024V  1 bit = 0.5mV    0.03125mV
   ads.setGain(GAIN_EIGHT);      // 8x gain   +/- 0.512V  1 bit = 0.25mV   0.015625mV
  // ads.setGain(GAIN_SIXTEEN);    // 16x gain  +/- 0.256V  1 bit = 0.125mV  0.0078125mV

  ads.begin();


}

void loop() {

  if(!digitalRead(rightbutton) && !rightbutton_State){
    rightbutton_State = true;
    display.clearDisplay();  
    display.setTextSize(1);    
    display.setCursor(20,14);
    display.setTextColor(WHITE);
    display.print("CALIBRATING...");     
    display.display();

    peltierOffset = setOffset(100);
    delay(10);
  }

  else if(digitalRead(rightbutton) && rightbutton_State){
    rightbutton_State = false;
  }

  if(!digitalRead(leftbutton) && !leftbutton_State){
    leftbutton_State = true;
    delay(10);
  }
  
  else if(digitalRead(leftbutton) && leftbutton_State){
    leftbutton_State = false;
  }

  peltierRead = ads.readADC_Differential_0_1() - peltierOffset; 
  float peltierVoltage = peltierRead*multiplier;

  float power = (10.8*peltierVoltage) + (0.0819*(pow(peltierVoltage,2)));     //Polinomic
  //float power = pow((4.95*peltierVoltage),1.29);                            //Exponencial

  display.clearDisplay();  
  display.setTextSize(3);    
  display.setCursor(15,7);
  display.setTextColor(WHITE);
  display.print(abs(power),0); 
  display.setTextSize(2); 
  display.println(" mW");   
  display.display();
  delay(100);


}




int16_t setOffset(int loopAmount){
  for (int i = 0; i<loopAmount; i++){
    peltierReadtemp += ads.readADC_Differential_0_1(); 
    delay(10);
  }
  int16_t read = peltierReadtemp/loopAmount;
  return read;
}













